require "prefabutil"
local assets =
{
	Asset("ANIM", "anim/spider_egg_sac.zip"),
    Asset("SOUND", "sound/spider.fsb"),
	Asset( "IMAGE", "images/inventoryimages/hound_item.tex" ),
    Asset( "ATLAS", "images/inventoryimages/hound_item.xml" ),
	Asset( "IMAGE", "images/inventoryimages/redhound_item.tex" ),
    Asset( "ATLAS", "images/inventoryimages/redhound_item.xml" ),
	Asset( "IMAGE", "images/inventoryimages/bluehound_item.tex" ),
    Asset( "ATLAS", "images/inventoryimages/bluehound_item.xml" ),
}

local function ondeploy(inst, pt) 
    --inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack")
    local hound = SpawnPrefab("hound_f") 
    if hound then 
        hound.Transform:SetPosition(pt.x, pt.y, pt.z) 
        inst.components.stackable:Get():Remove()
    end 
end

local function ondeploy2(inst, pt) 
    --inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack")
    local hound = SpawnPrefab("redhound_f") 
    if hound then 
        hound.Transform:SetPosition(pt.x, pt.y, pt.z) 
        inst.components.stackable:Get():Remove()
    end 
end

local function ondeploy3(inst, pt) 
    --inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack")
    local hound = SpawnPrefab("bluehound_f") 
    if hound then 
        hound.Transform:SetPosition(pt.x, pt.y, pt.z) 
        inst.components.stackable:Get():Remove()
    end 
end

local function ondeploy4(inst, pt) 
    --inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack")
    local hound = SpawnPrefab("venomhound_f") 
    if hound then 
        hound.Transform:SetPosition(pt.x, pt.y, pt.z) 
        inst.components.stackable:Get():Remove()
    end 
end

local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("spider_egg_sac")
    inst.AnimState:SetBuild("spider_egg_sac")
    inst.AnimState:PlayAnimation("idle")
    
	
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
    
	MakeSmallBurnable(inst, TUNING.LARGE_BURNTIME)
    MakeSmallPropagator(inst)
    
    inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.imagename = "monster_wpn"  
    
    inst.components.inventoryitem:SetOnPickupFn(function() inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack") end)
    
    inst:AddComponent("deployable")
    inst.components.deployable.test = function() return true end
    
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bluehound_item.xml"
	inst.components.deployable.ondeploy = ondeploy3

    return inst
end

local function fndefault(Sim)
	local inst = fncommon(Sim)
	
   
	return inst
end

local function fnfire(Sim)
	local inst = fncommon(Sim)
	inst.components.inventoryitem.atlasname = "images/inventoryimages/redhound_item.xml"
	inst.components.deployable.ondeploy = ondeploy2
	
	return inst
end

local function fncold(Sim)
	local inst = fncommon(Sim)
	inst.components.inventoryitem.atlasname = "images/inventoryimages/bluehound_item.xml"
	inst.components.deployable.ondeploy = ondeploy3

	return inst
end

return Prefab( "common/inventory/bluehound_item", fncommon, assets),
	   --Prefab( "common/inventory/redhound_item", fnfire, assets),
	   --Prefab( "common/inventory/bluehound_item", fncold, assets),
	   MakePlacer( "common/bluehound_item_placer", "hound", "hound", "idle" ) 

